/**
* \file: AilAudioSinkImpl.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* Actual implementation of AilAudioSink class (see pImpl idiom)
*
* \component: Baidu CarLife
*
* \author: P. Govindaraju / RBEB/GM / Pradeepa.Govindaraju@in.bosch.com
*          P. Acar / ADIT/SW2 / pacar@de.adit-jv.com
*
* \copyright (c) 2016-2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef BDCL_AILAUDIOSINKIMPL_H
#define BDCL_AILAUDIOSINKIMPL_H

#include <string>
#include <memory>
#include <deque>
#include <condition_variable>
#include <mutex>
#include <atomic>
#include <AudioStreaming.h>
#include <adit_logging.h>
#include <bdcl/AditBackendCallbacks.h>
#include <bdcl/BaiduCoreCallbackDealer.h>
#include <bdcl/AditAudioSink.h>
#include "AilAudioConfig.h"
#include "AilAudioSinkRecord.h"

namespace adit { namespace utility { namespace audio {
class Backend;
class StreamStatistics;
};};};

namespace adit { namespace bdcl {

class AilAudioSinkImpl : public adit::utility::audio::Streaming, public IAudioSinkBackendCallbacks
{
public:
    AilAudioSinkImpl(IAditAudioSinkCallbacks* inCallbacks, CoreCallbackDealer* inCallbackDealer);
    ~AilAudioSinkImpl();

    /* pImpl idiom: same methods as AilAudioSink */
    void setConfigItem(std::string inKey, std::string inValue);
    bool initialize();
    void teardown();
    bool playbackStart();
    bool playbackStop(bool inFlushBuffer);

    /* IAudioSinkBackEndCallbacks */
    void onAudioDataAvailable(uint8_t *inData, uint32_t inLen);
    void onPlaybackInterruptBackend();

private:
    /* Baidu core callbacks to be consumed by MC */
    // todo reference instead of ptr?
    IAditAudioSinkCallbacks* mCallbacks;

    AilAudioSinkConfig mConfig;
    int mChangedConfigParams;
    bool mIsSetThreadParam;
    bool mAudioSinkRecordRunning;
    AilAudioSinkRecord mAudioSinkRecord;
    std::shared_ptr<adit::utility::audio::Backend> mAilBackend;

    CoreCallbackDealer* mCallbackDealer;

    /* AIL logging callbacks to be consumed by ADIT */
    void error(const std::string& inData) const final;
    void warning(const std::string& inData) const final;
    void info(const std::string& inData) const final;
    void debug(const std::string& inData) const final;
    adit::utility::eLogLevel checkLogLevel() const final;

    /* AIL streaming callbacks to be consumed by ADIT */
    adit::utility::audio::AudioState processing(unsigned char *in, unsigned char **out, uint32_t &frames) final;
    void statistics(const adit::utility::audio::StreamStatistics &status) final;
    void eostreaming(const adit::utility::audio::AudioError error) final;

    /* Helper functions */
    bool _startStream();
    void _streamToAil();
    bool _stopStream(bool inFlushBuffer);
    void _flushBuffer();
    void _setThreadPriority();

    class AudioItem
    {
    public:
        AudioItem(AilAudioSinkImpl* sink, uint8_t* dataPtr, size_t len, size_t sampleRate, size_t channelNumber, size_t sampleFormat) :
            mSink(sink), mDataPtr(dataPtr), mLen(len), mSampleRate(sampleRate), mChannelNumber(channelNumber), mSampleFormat(sampleFormat),
            mWasPlayed(false) { }

        AilAudioSinkImpl* mSink;
        // todo investigate if this is leaking
        uint8_t* mDataPtr;
        size_t mLen;
        size_t mSampleRate;
        size_t mChannelNumber;
        size_t mSampleFormat;
        bool mWasPlayed;
    };
    std::deque<std::shared_ptr<AudioItem>> mAudioItemDeque;

    // todo naming convention with prefix m and camel case
    std::mutex audioMut;
    std::condition_variable cvAudioAvailable;

    std::mutex mutAudioStatus;
    std::condition_variable cvAudioStatus;


    enum struct audioStatus{
        initializing,
        buffering,
        streaming,
        draining,
        shuttingDown,
        interrupting
    };
    audioStatus mStatus;
    audioStatus _getState();
    void _setState(audioStatus inStatus);
    unsigned int _convByteToTime(uint32_t inLen, size_t sampleRate, size_t channelNumber, size_t sampleFormat);


    int32_t mPlayItemTimeMs;
    unsigned int bufferTimeCurMs;
};

} } /* namespace adit { namespace bdcl { */

#endif /* BDCL_AILAUDIOSINKIMPL_H */
